\version "2.18.0"

\paper {
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Tatăl nostru"
  %subtitle = "Vino din Liban, mireasă"
  composer =  \markup \center-column { "Ioan Dumitru Chirescu" \small 
  "(1889 — 1980)" }
  meter = "Andantino mosso (quasi recitativo)"
  tagline=""
}

global = {
  \key f \major
  %\cadenzaOn
  \autoBeamOff
  \time 3/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Ta -- tăl no -- stru, ca -- re eşti în ce -- ruri,
  sfin -- ţea -- scă- -- se nu -- me -- le Tău.
  Vi -- e îm -- pă -- ră -- ţi -- a Ta,
  fa -- că -- se vo -- ia Ta,
  pre -- cum în cer, a -- şa şi pe pă -- mânt. 
  
  Pâi -- nea noa -- stră cea de toa -- te zi -- le -- le
  dă -- ne-o no -- uă as -- tăzi
  şi ne iar -- tă no -- uă gre -- şe -- li -- le noa -- stre,
  pre -- cum şi noi ier -- tăm gre -- şi -- ţi -- lor no -- ştri.

  Şi nu ne du -- ce pe noi în -- tru is -- pi -- tă,
  ci ne iz -- bă -- veş -- te de cel vi -- clean.
}

tenorWords = \lyricmode {
  Ta -- tăl no -- stru, ca -- re eşti în ce -- ruri,
  sfin -- ţea -- scă- -- se nu -- me -- le Tău.
  Vi -- e îm -- pă -- ră -- ţi -- a Ta,
  fa -- că -- se vo -- ia Ta,
  pre -- cum în cer, a -- şa şi pe pă -- mânt. 
  
  Pâi -- nea noa -- stră cea de toa -- te zi -- le -- le
  dă -- ne-o no -- uă as -- tăzi
  şi ne iar -- tă no -- uă gre -- şe -- li -- le noa -- stre,
  pre -- cum şi noi ier -- tăm gre -- şi -- ţi -- lor no -- ştri.

  ci ne iz -- bă -- veş -- te de cel vi -- clean.
}

bassWords = \lyricmode {
  Ta -- tăl no -- stru, ca -- re eşti în ce -- ruri,
  sfin -- ţea -- scă- -- se nu -- me -- le Tău.
  Vi -- e îm -- pă -- ră -- ţi -- a Ta,
  fa -- că -- se vo -- ia Ta,
  pre -- cum în cer, a -- şa şi pe pă -- mânt. 
  
  Pâi -- nea noa -- stră cea de toa -- te zi -- le -- le
  dă -- ne-o no -- uă as -- tăzi
  şi ne iar -- tă no -- uă gre -- şe -- li -- le noa -- stre,
  pre -- cum şi noi ier -- tăm gre -- şi -- ţi -- lor no -- ştri.  
    
  Şi nu ne du -- ce 
  ci ne iz -- bă -- veş -- te de cel vi -- clean.
}

sopMusic = \relative c'' {
  \time 2/8 a8^\p^\markup{ \italic "mezza voce" } g8 | % 2
  \time 3/4  g4 f2 | % 3
  \time 2/4  a8 a bes g | % 4
  \autoBeamOn
  \time 3/4  g4 f4. f8 | % 5
  \time 2/4 \times 2/3 { g8 g^\markup{ \italic "poco rit."} g8 }
  \times 2/3 { e8 d8 e8 } | % 6
  \time 3/4  f2 r4 
  \autoBeamOff
  g4^\accent^\markup"a tempo" g8 
  g ^\< g8 g \! | % 8
  \times 2/3  { bes4 a8 ^\> } g2 \! | % 9
  \time 2/4  a4 -> a8 a8 | 
  \time 3/4  c8. -> a16 c4.^\< c8 | % 11
  d8 e8 \! f4. ^\fp -> f,8 
  \autoBeamOff
  a8 a8 g4^\> a4 | % 14
  f2 \! r4 \fermata | % 15
  \time 2/8  a8 ^\markup{ \italic "sempre mezza voce"} ^\pp g8 | % 16
  \time 3/4  g4 f2 | % 17
  \time 2/4  a8 a8 bes8 g8 | % 18
  \times 2/3  {g4 f8} f4 g8 g
  \autoBeamOn
  \times 2/3 { e( d) e}
  \time 3/4  f4^\> f4 \! r4 | % 21
  \autoBeamOff
  \time 2/4  g8^\markup"a tempo" g g ^\< g8 \! | % 22
  \time 3/4  \times 2/3 { bes4 ^\> ( a8 ) }
  g4. \! a8 | % 23
  \time 2/4  c4 ^\markup{ \italic "cresc."} c8. a16 
  \time 3/4  c4 c4. \breathe c8 ^\< 
  \time 2/8  | % 25
  d8 e8 \!
  \time 2/4  f4. ^\accent f,8 | % 27
  f4. f8 | % 28
  a4 ^\accent g8 a8 | % 29
  \time 3/4  f2 ^\> f8 \! r8 ^\markup"Un poco meno mosso" 
  \bar"||"
  \key a \minor
  \time 2/4  r8 ^\markup { "Solo" \italic "dolce" }
  a8 b8 c8 a4 a4
  \time 3/4  r8 a8 c8 c8 b8 c8 | % 33
  \time 2/4  a4 ^\> a4 \! | % 34
  a8 ^\p ^\markup"Tutti - a tempo" a8 a8 a8 | % 35
  c4  ^\markup{ \italic "cresc." }c8 c8 | % 36
  \time 4/4  c2.^\< ^\markup{ \italic "rit." }
  c4 ^\> ^\f
  << c1 \fermata { s4 s\! s^\p } >>
  \bar "|."
}

altMusic = \relative c' {
  f8 e8 e4 d2 f8 f g e 
  \autoBeamOn
  e4 d4. d8 
  \times 2/3 { e8 e8 e8 }
  \times 2/3 { e8 d8 e8 }
  f2 r4 
  \autoBeamOff
  e4 e8 e e e
  \times 2/3 { g4 f8} e2 
  f4 f8 f8 a8. f16 a4. a8 
  a8 g f4. f8 e8 e8 e4 e4 f2 r4 
  f8 e e4 d2 f8 f g e
  \times 2/3  { e4 d8 } d4
  
  e8 e \autoBeamOn \times 2/3 { e( d) e }
  \autoBeamOff f4 f r e8 e e e
  \times 2/3 { g4( f8) }
  e4. f8 
  a4 a8. f16 a4 a4. a8 a g f4. f8 
  f4. f8 e4 e8 e f2 f8 r
  \key a \minor
  r1*2/4 r1*2/4 r1*3/4 r1*2/4 
  a8 a a a g4 g8 g f2 f e1  
}

tenorMusic = \relative c' {
  c8 c a4 a2 c8 c c c a4 a4. a8 
  \autoBeamOn
  \times 2/3 { c8 c c } \times 2/3 { bes8 bes bes }
  a2 r4 
  \autoBeamOff
  c4 c8 c c c 
  \times 2/3  { c4 c8 } c2 
  c4 c8 c c8. c16 c4. c8 c c a4. a8 
  c8 c bes4 bes4 a2 r4 
  c8 c a4 a2 c8 c c c 
  \times 2/3  { a4 a8 } a4
  c8 c \times 2/3 { bes4 bes8 }
  a4 a r c8 c c c c4 c4. c8 
  c4 c8. c16 c4 c4. c8
  c8 c a4. a8 a4. a8 c4 bes8 bes 
  a2 a8 r 
  \key a \minor
  r1*2/4 r1*2/4 r1*3/4 r1*2/4
  c8 c c c c4 c8 c a2 g2 g1  
}

bassMusic = \relative c {
  f8 c d4 d2 f8 f e c 
  \autoBeamOn
  d4 d4. d8  
   <<
    { \voiceOne
      \times 2/3 {c8 c c} \times 2/3 {g' g g}
      }
    \new Voice 
      { \voiceTwo
        \times 2/3 {c,8 c c} \times 2/3 {c c c}
      }
   >>
  \oneVoice
  f2 r4
  \autoBeamOff
  c4 c8 c c c 
  \times 2/3  { e4 f8} c2 
  f4 f8 f f8. f16 f4. a8 f8 e8  d4. d8
  \autoBeamOff
  c8 c c4 c <f f,>2 r4
  f8 c d4 d2 f8 f e c
  \times 2/3  { d4 d8 }
  d4
  <<
    { \voiceOne
      c8 c \times 2/3 {g'4 g8}
    }
    \new Voice 
      { \voiceTwo
        \autoBeamOff 
        c,8 c \times 2/3 {c4 c8}
      }
  >>
  \oneVoice
  f4 f r 
  \autoBeamOff
  c8 c c c
  \times 2/3 {e4( f8)} c4. f8 
  f4 f8. f16 f4 f4. a8 f e d4. d8
  d4. d8 c4 c8 c8  \time 3/4  f2 f8  r8 
  \key a \minor
  <<
    { \voiceOne
      e2 e4 e4 e2. e2  
    }
    \new Voice 
    { \voiceTwo
      a,2 a4 a4 a2. a2    
    }
  >>
  \oneVoice
  f'8 f f f e4 e8 e
  d2 d2 c1
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \sopMusic }
      \addlyrics { \sopWords }
    >>

   \new Staff <<
      \new Voice { \global \altMusic }
      \addlyrics { \tenorWords }
    >>
    
   \new Staff <<
      \clef "G_8"
      \new Voice { \global \tenorMusic }
      \addlyrics { \tenorWords }
    >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }    
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
